﻿//////////////////////////////////////////////
// RenderScenePass.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class Camera ;
	class BlendState ;
	class DepthStencilState ;
	class RasterState ;
	class RenderQueue ;
}

/// Includes ---------------------------------

// nkGraphics
#include "Pass.h"

#include "../Dll/DllDefines.h"

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

/// Class ------------------------------------
	
namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT RenderScenePass : public Pass
	{		
		public :
		
			// Getters
			RenderQueue* getRenderQueue () const ;
			Camera* getRenderCamera () const ;
			Camera* getCullingCamera () const ;
			Camera* getLodCamera () const ;
			BlendState* getBlendState () const ;
			RasterState* getRasterState () const ;
			DepthStencilState* getDepthStencilState () const ;
			bool isTransparentPass () const ;

			// Setters
			void setRenderQueue (RenderQueue* queue) ;
			void setRenderCamera (Camera* cam) ;
			void setCullingCamera (Camera* cam) ;
			void setLodCamera (Camera* cam) ;
			virtual void setBlendState (BlendState* state) ;
			virtual void setRasterState (RasterState* state) ;
			virtual void setDepthStencilState (DepthStencilState* state) ;
			void setTransparentPass (bool value) ;

			// L'export et import
			virtual void exportClassToTree (nkExport::Node* rootNode) override ;
			virtual void importClassFromTree (nkExport::Node* rootNode) override ;

		protected :

			// Functions
			// Constructor
			RenderScenePass (System* system) noexcept ;

		protected :

			// Attributes
			RenderQueue* _renderQueue ;

			// Overloaded cameras
			Camera* _renderCamera ;
			Camera* _cullingCamera ;
			Camera* _lodCamera ;

			// States
			BlendState* _blendState ;
			RasterState* _rasterState ;
			DepthStencilState* _depthState ;

			// Transparent
			bool _transparentPass ;
	} ;
}